##########################################################################
#
# pgAdmin 4 - PostgreSQL Tools
#
# Copyright (C) 2013 - 2026, The pgAdmin Development Team
# This software is released under the PostgreSQL Licence
#
##########################################################################

import uuid
import json

from pgadmin.browser.server_groups.servers.databases.schemas.tests import \
    utils as schema_utils
from pgadmin.browser.server_groups.servers.databases.tests import utils as \
    database_utils
from pgadmin.utils.route import BaseTestGenerator
from regression import parent_node_dict
from regression.python_test_utils import test_utils as utils
from . import utils as sequence_utils


class SequenceDeleteMultipleTestCase(BaseTestGenerator):
    """This class will delete added sequence under schema node."""
    scenarios = [
        # Fetching default URL for sequence node.
        ('Fetch sequence Node URL', dict(url='/browser/sequence/obj/'))
    ]

    def setUp(self):
        super().setUp()
        self.db_name = parent_node_dict["database"][-1]["db_name"]
        schema_info = parent_node_dict["schema"][-1]
        self.server_id = schema_info["server_id"]
        self.db_id = schema_info["db_id"]
        db_con = database_utils.connect_database(self, utils.SERVER_GROUP,
                                                 self.server_id, self.db_id)
        if not db_con['data']["connected"]:
            raise Exception("Could not connect to database to add sequence.")
        self.schema_id = schema_info["schema_id"]
        self.schema_name = schema_info["schema_name"]
        schema_response = schema_utils.verify_schemas(self.server,
                                                      self.db_name,
                                                      self.schema_name)
        if not schema_response:
            raise Exception("Could not find the schema to add sequence.")
        self.sequence_name = "test_sequence_delete_%s" % str(uuid.uuid4())[1:8]
        self.sequence_name_1 = "test_sequence_delete_%s" %\
                               str(uuid.uuid4())[1:8]

        self.sequence_ids = [sequence_utils.create_sequences(
            self.server,
            self.db_name,
            self.schema_name,
            self.sequence_name),
            sequence_utils.create_sequences(
                self.server,
                self.db_name,
                self.schema_name,
                self.sequence_name_1)
        ]

    def runTest(self):
        """ This function will delete added sequence under schema node. """
        sequence_response = sequence_utils.verify_sequence(self.server,
                                                           self.db_name,
                                                           self.sequence_name)
        if not sequence_response:
            raise Exception("Could not find the sequence to delete.")

        sequence_response = sequence_utils.verify_sequence(self.server,
                                                           self.db_name,
                                                           self.sequence_name_1
                                                           )
        if not sequence_response:
            raise Exception("Could not find the sequence to delete.")

        data = json.dumps({'ids': self.sequence_ids})
        response = self.tester.delete(
            self.url + str(utils.SERVER_GROUP) + '/' +
            str(self.server_id) + '/' +
            str(self.db_id) + '/' +
            str(self.schema_id) + '/',
            follow_redirects=True,
            data=data,
            content_type='html/json'
        )
        self.assertEqual(response.status_code, 200)

    def tearDown(self):
        # Disconnect the database
        database_utils.disconnect_database(self, self.server_id, self.db_id)
